package gov.va.med.mhv.vitals.dto;

import java.io.Serializable;
import java.math.BigDecimal;

import javax.xml.bind.annotation.XmlRootElement;

import com.fasterxml.jackson.annotation.JsonIgnore;

import gov.va.med.mhv.vitals.enums.InrHighEndTargetRangeEnumeration;
import gov.va.med.mhv.vitals.enums.InrLowEndTargetRangeEnumeration;

@XmlRootElement(name = "InrReadingDTO")
public class InrReadingDTO extends AbstractDTO implements Serializable{
	
	private static final long serialVersionUID = -6823004014192954393L;
	private Long inrId;
	private BigDecimal inr;
	private InrLowEndTargetRangeEnumeration lowendTargetRange = InrLowEndTargetRangeEnumeration.NONE;
	private InrHighEndTargetRangeEnumeration highendTragetRange = InrHighEndTargetRangeEnumeration.NONE;
	private String location;
	private String provider;
	private String comments;
	private Long userprofileId;
	public Long getInrId() {
		return inrId;
	}
	public void setInrId(Long inrId) {
		this.inrId = inrId;
	}
	public BigDecimal getInr() {
		return inr;
	}
	public void setInr(BigDecimal inr) {
		this.inr = inr;
	}
	public String getLowendTargetRange() {
		return lowendTargetRange.name();
	}
	public void setLowendTargetRange(String lowendTargetRange) {
		this.lowendTargetRange = InrLowEndTargetRangeEnumeration.valueOf(lowendTargetRange);
	}
	public String getHighendTragetRange() {
		return highendTragetRange.name();
	}
	public void setHighendTragetRange(String highendTragetRange) {
		this.highendTragetRange = InrHighEndTargetRangeEnumeration.valueOf(highendTragetRange);
	}
	public String getLocation() {
		return location;
	}
	public void setLocation(String location) {
		this.location = location;
	}
	public String getProvider() {
		return provider;
	}
	public void setProvider(String provider) {
		this.provider = provider;
	}
	public String getComments() {
		return comments;
	}
	public void setComments(String comments) {
		this.comments = comments;
	}
	public Long getUserprofileId() {
		return userprofileId;
	}
	public void setUserprofileId(Long userprofileId) {
		this.userprofileId = userprofileId;
	}
	@JsonIgnore
	public String getDisplayINRLowendTarget() {
		return this.lowendTargetRange.getDescription();
	}
	@JsonIgnore
	public String getDisplayINRHighendTarget() {
		return this.highendTragetRange.getDescription();
	}
	@JsonIgnore
	public InrLowEndTargetRangeEnumeration[] getLowendTargets() {
		return InrLowEndTargetRangeEnumeration.values();
	}
	@JsonIgnore
	public InrHighEndTargetRangeEnumeration[] getHighendTargets() {
		return InrHighEndTargetRangeEnumeration.values();
	}

}
